﻿using System;
using System.Collections.Generic;
using Microsoft.Reporting.WebForms;

namespace VIRP_WEB.Custom.EFR
{
    [Serializable]
    public class ReportViewerHandler
    {
        List<ReportParameter> ReportParameters;

        public void ClearParams()
        {
            this.ReportParameters.Clear();
        }

        public void AddReportVariable(string paramName, string paramValue)
        {
            ReportParameter reportParam = new ReportParameter(paramName, paramValue);
            this.ReportParameters.Add(reportParam);
        }

        public void SetReportParameters(ReportViewer rv)
        {
            rv.LocalReport.SetParameters(this.ReportParameters.ToArray());
        }

        public void SetServerReportParameters(ReportViewer rv)
        {
            rv.ServerReport.SetParameters(this.ReportParameters.ToArray());
        }

        public ReportViewerHandler()
        {
            // save date
            this.ReportParameters = new List<ReportParameter>();
        }
    }
}